#ifndef __CSystemInformation__
#define __CSystemInformation__

#include "../Basics/CString.hpp"
#include "SSystemInformation.hpp"
#include "../IO/CTextStream.hpp"

//	===========================================================================

using Exponent::Host::SSystemInformation;
using Exponent::Basics::CString;
using Exponent::IO::CTextStream;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CSystemInformation CSystemInformation.hpp
		 * @brief Provides info about the host system.
		 *
		 * DO NOT call CPU speed in any tight loops. Its is VERY cpu heavy and will kill\n
		 * your other threads. Use at load / idle only. And dont rely on it for computing timers\n
		 * or anything else of that nature
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Added stream output and made writing all stream based (yay for streams!!)
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CSystemInformation.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CSystemInformation
		{
		public:

//	===========================================================================

			/**
			 * Get the info about the system
			 * @param sys On return is filled with system information
			 */
			static void getSystemInfo(SSystemInformation &sys);

//	===========================================================================

			/**
			 * Dump all information to a text file
			 * @param path The path to write the data to
			 */
			static void dumpSystemInfoToFile(CSystemString &path);

			/**
			 * Output the system logs to the the supplied stream
			 * @param stream The text stream
			 */
			static void dumpSystemInfoToFile(CTextStream &stream);

//	===========================================================================

			/**
			 * Get the number of processors
			 * @retval long The number of processors
			 */
			static long getNumberOfProcessors();

//	===========================================================================

			/**
			 * Get the computer name
			 * @retval CString On return filled with the computer name
			 */
			static CString getComputerName();

			/**
			 * Get the logged on user name
			 * @retval const CString The name of the current user
			 */
			static CString getUserName();

//	===========================================================================

			/**
			 * Get a string representing the os version
			 * @param string On return stores the os version
			 * @retval bool True if filled string properly, false otherwise
			 */
			static bool getOperatingSystemVersion(CString &string);

			/**
			 * Get the operating system version
			 * @param major On return holds the os major verison
			 * @param minor On return holds the os minor version
			 * @param build On return holds the os build version
			 */
			static void getOsVersionInfo(long &major, long &minor, long &build);

//	===========================================================================

			/**
			 * Get a string representing the CPU
			 * @retval CString On return stores a string representing the CPU speed
			 */
			static CString getCpuNameString();

			/**
			 * Get the CPU speed
			 * @retval long The CPU speed
			 */
			static long getCpuSpeed();

//	===========================================================================
/** @cond */
#ifdef WIN32
/**  @endcond */
			/**
			 * Determine the time stamp for measuring CPU speed
			 * @retval DWORD The time stamp
			 */
			static DWORD determineTimeStamp();

/** @cond */
#endif
/** @endcond */

		};
	}
}
#endif	// End of CSystemInformation.hpp
